<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" >
                            <h5 class="card-title"> Estudantes da: {{ $model->class }} classe / {{ $model->name }}</h5>
                            <form wire:submit.prevent="updateStudent">
                            <div class="row">
                                <div class="col-md-3">
                                    <label for="classroom1" class="form-label">Passar para:</label>
                                    <select class="form-select" wire:model="classroom1" >
                                        @foreach($classroom as $class)
                                        <option value="{{ $class->id }}">{{$class->class}} - {{$class->name}} </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label for="classstatus" class="form-label"> De: </label>
                                    <select class="form-select" wire:model="year" required>
                                        <option >Selecione o ano</option>
                                        <option value="2023">2023</option>
                                        
                                        
                                    </select>
                                    @error('year_edu') <span class="error">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-md-6">
                                    <select class="form-select" multiple wire:model="studentid" size="12" >
                                        @foreach($models as $model)
                                        <option value="{{ $model->id }}">{{$model->name}} 
                                            @if( $model->year_edu == date('Y') )
                                                {{ "- Estudante promovido" }}
                                            @else
                                                {{ "- Estudante não promovido " }}
                                            @endif
                                         </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-3" style="margin-top: 37px;">
                                    <label for="classstatus" class="form-label"> Passar: </label>
                                    <input type="radio" name="classstatus" wire:model="classstatus" value="passed" />
                                    <label for="classstatus" class="form-label"> Reprovar:  </label>
                                    <input type="radio" name="classstatus" wire:model="classstatus" value="failed" />
                                </div>
                                <div class="col-md-3">
                                    <label for="classstatus" class="form-label"> Ano: </label>
                                    <select class="form-select" wire:model="year_edu" required>
                                        <option >Selecione o ano</option>
                                        <option value="2023">2023</option>
                                        <option value="2024" selected>2024</option>
                                        <option value="2025">2025</option>
                                        <option value="2026">2026</option>
                                        <option value="2027">2027</option>
                                        <option value="2028">2028</option>
                                        <option value="2029">2029</option>
                                        <option value="2030">2030</option>
                                        <option value="2031">2031</option>
                                        
                                    </select>
                                    @error('year_edu') <span class="error">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-md-6" style="margin-top: 29px;">
                                    <button type="submit" class="form-control">Atualizar classe/turma</button>
                                </div>
                            </div>
                            </form> 
                            
                            <div class="table-responsive" style="display:none;">
                                @if(count($models))
                                    <table class="table table-hover">
                                        <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">Escolher os estudantes para passagem de classe</th>
                                            <th scope="col">Nome</th>
                                            <th scope="col">Sexo</th>
                                            <th scope="col">Data de Nascimento</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">ID do Estudante</th>
                                            <th scope="col">Turma</th>
                                            <th scope="col">Classe</th>
                                            <th scope="col">Data/Hora</th>

                                        </tr>
                                        </thead>
                                        <tbody>
                                        @php($count = 1)
                                        @foreach($models as $model)
                                            <tr>
                                                <th scope="row">{{ $count++ }}</th>
                                                <td><input wire:model="student_id[]" type="checkbox" name="student_id[]" /></td>
                                                <td>{{ $model->name }}</td>
                                                <td>{{ $model->sex }}</td>
                                                <td>{{ $model->dob }}</td>
                                                <td>{{ $model->email }}</td>
                                                <td>{{ $model->student_id }}</td>
                                                <td>{{ $model->class->name }}</td>
                                                <td>{{ $model->class->class }} &nbsp;&nbsp; Classe</td>
                                                <td>{{ date('F d, Y h:i a', strtotime($model->created_at)) }}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                    <div class="row float-end">
                                        {{ $models->links() }}
                                    </div>
                                @else
                                    <br>
                                    <br>
                                    <div  class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
