<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Trusthub
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Trusthub\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;


/**
 * @property string|null $inquiryId
 * @property string|null $inquirySessionToken
 * @property string|null $tollfreeId
 * @property string|null $url
 */
class ComplianceTollfreeInquiriesInstance extends InstanceResource
{
    /**
     * Initialize the ComplianceTollfreeInquiriesInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $tollfreeId The unique TolfreeId matching the Compliance Tollfree Verification Inquiry that should be resumed or resubmitted. This value will have been returned by the initial Compliance Tollfree Verification Inquiry creation call.
     */
    public function __construct(Version $version, array $payload, string $tollfreeId = null)
    {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'inquiryId' => Values::array_get($payload, 'inquiry_id'),
            'inquirySessionToken' => Values::array_get($payload, 'inquiry_session_token'),
            'tollfreeId' => Values::array_get($payload, 'tollfree_id'),
            'url' => Values::array_get($payload, 'url'),
        ];

        $this->solution = ['tollfreeId' => $tollfreeId ?: $this->properties['tollfreeId'], ];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return ComplianceTollfreeInquiriesContext Context for this ComplianceTollfreeInquiriesInstance
     */
    protected function proxy(): ComplianceTollfreeInquiriesContext
    {
        if (!$this->context) {
            $this->context = new ComplianceTollfreeInquiriesContext(
                $this->version,
                $this->solution['tollfreeId']
            );
        }

        return $this->context;
    }

    /**
     * Update the ComplianceTollfreeInquiriesInstance
     *
     * @param string $did The Tollfree phone number to be verified
     * @return ComplianceTollfreeInquiriesInstance Updated ComplianceTollfreeInquiriesInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(string $did): ComplianceTollfreeInquiriesInstance
    {

        return $this->proxy()->update($did);
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name)
    {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Trusthub.V1.ComplianceTollfreeInquiriesInstance ' . \implode(' ', $context) . ']';
    }
}

